% TA level solver for Stocking Rate
%
% We want to solve for the coefficients for the following model:
% Y = a log(X - b)
%
% Where X = year
% And Y = stocking rate (animals per hectare)
%
% Simon Anastasiadis 03/10/2011

clc

%% raw data for LIC stocking rates

year = [1999 2000 2001 2002 2003 2004 2005 2006 2007 2008];

prod_anim_matrix = ...
   [3.00, 3.10, 3.03, 2.97, 3.15, 3.27, 3.32, 3.36, 3.42, 3.35;...
    2.00, 1.80, 1.79, 1.74, 1.93, 1.89, 1.86, 1.98, 2.02, 2.06;...
    2.30, 2.30, 2.32, 2.18, 2.27, 2.37, 2.33, 2.38, 2.45, 2.38;...
    2.90, 2.60, 2.68, 2.63, 2.75, 2.69, 2.68, 2.72, 2.68, 2.65;...
    2.60, 2.80, 2.82, 2.77, 2.86, 2.87, 2.90, 2.81, 2.72, 3.00;...
    3.30, 2.80, 2.67, 2.82, 2.93, 3.33, 3.31, 3.27, 3.56, 3.38;...
    2.80, 2.70, 2.72, 2.62, 2.73, 2.74, 2.74, 2.76, 2.82, 2.74;...
    3.00, 2.40, 2.44, 2.38, 2.51, 2.57, 2.61, 2.64, 2.73, 2.71;...
    2.10, 2.10, 2.08, 2.04, 2.10, 2.13, 2.11, 2.11, 2.14, 2.13;...
    2.50, 2.40, 2.40, 2.36, 2.46, 2.49, 2.48, 2.49, 2.52, 2.51;...
    2.90, 2.50, 2.84, 2.74, 3.09, 2.58, 3.17, 2.51, 2.29, 2.55;...
    2.90, 2.70, 2.67, 2.72, 2.74, 2.76, 2.70, 2.70, 2.70, 2.65;...
    1.90, 2.00, 2.13, 2.03, 2.15, 2.18, 2.19, 2.31, 2.35, 2.40;...
    2.50, 2.70, 2.70, 2.80, 3.28, 3.06, 2.98, 3.05, 3.08, 3.00;...
    2.80, 2.60, 2.64, 2.58, 2.74, 2.75, 2.75, 2.79, 2.79, 2.80;...
    2.80, 2.60, 2.65, 2.53, 2.67, 2.74, 2.73, 2.70, 2.73, 2.78;...
    2.90, 2.90, 2.85, 2.82, 2.91, 2.93, 2.94, 3.05, 3.08, 3.19;...
    2.60, 2.40, 2.51, 2.47, 2.59, 2.69, 2.57, 2.61, 2.64, 2.70;...
    2.60, 2.60, 2.73, 2.41, 2.74, 2.74, 2.72, 2.69, 2.74, 2.86;...
    2.10, 2.20, 2.15, 2.09, 2.19, 2.20, 2.16, 2.19, 2.21, 2.23;...
    2.90, 2.40, 2.54, 2.42, 2.46, 2.53, 2.45, 2.39, 2.56, 2.61;...
    2.80, 2.80, 2.70, 2.62, 2.78, 2.83, 2.83, 2.86, 2.88, 2.86;...
    2.80, 2.60, 2.68, 2.55, 2.67, 2.71, 2.67, 2.74, 2.79, 2.80;...
    2.70, 2.60, 2.64, 2.36, 2.53, 2.65, 2.83, 2.69, 2.81, 2.76;...
    2.80, 2.40, 2.46, 2.51, 2.65, 2.71, 2.72, 2.74, 2.79, 2.79;...
    2.80, 2.70, 2.79, 2.83, 2.78, 2.93, 3.06, 2.90, 2.91, 2.94;...
    3.00, 3.00, 3.00, 2.95, 3.11, 3.15, 3.14, 3.19, 3.22, 3.20;...
    2.50, 2.70, 2.47, 2.37, 2.60, 2.57, 2.80, 2.83, 2.85, 2.65;...
    3.10, 2.40, 2.24, 2.50, 2.66, 2.71, 2.69, 2.77, 2.78, 2.81;...
    2.60, 2.60, 2.64, 2.55, 2.68, 2.68, 2.68, 2.69, 2.69, 2.69;...
    2.70, 2.70, 2.67, 2.61, 2.75, 2.78, 2.77, 2.81, 2.83, 2.83;...
    2.70, 2.70, 2.69, 2.63, 2.76, 2.79, 2.78, 2.81, 2.82, 2.82;...
    2.70, 2.70, 2.70, 2.68, 2.82, 2.74, 2.77, 2.82, 2.78, 2.73;...
    2.70, 2.90, 2.85, 2.78, 2.96, 2.95, 2.95, 2.94, 2.93, 2.93;...
    2.90, 2.60, 2.90, 2.58, 2.82, 2.83, 2.73, 2.72, 2.66, 2.74;...
    2.50, 2.80, 2.58, 2.62, 2.54, 2.46, 2.25, 2.30, 2.16, 2.23;...
    2.70, 2.70, 2.75, 2.63, 2.79, 2.86, 2.81, 2.93, 2.90, 2.83;...
    2.10, 2.20, 2.19, 2.25, 2.25, 2.24, 2.24, 2.30, 2.32, 2.29;...
    2.50, 2.70, 2.68, 2.64, 2.74, 2.73, 2.71, 2.73, 2.75, 2.76;...
    2.30, 2.40, 2.42, 2.48, 2.41, 2.56, 2.30, 2.59, 2.46, 2.59;...
    3.00, 2.70, 2.82, 2.83, 2.96, 3.05, 3.16, 3.20, 3.33, 3.36;...
    2.70, 2.60, 2.58, 2.55, 2.68, 2.74, 2.75, 2.80, 2.86, 2.87;...
    2.90, 2.90, 2.94, 2.83, 2.96, 2.98, 2.95, 2.97, 2.98, 2.98;...
    2.70, 2.90, 2.89, 2.79, 2.95, 2.95, 2.95, 2.99, 2.98, 3.01;...
    2.60, 2.70, 2.77, 2.61, 2.75, 2.80, 2.73, 2.75, 2.76, 2.85;...
    2.70, 2.60, 2.58, 2.58, 2.66, 2.69, 2.69, 2.70, 2.74, 2.75;...
    2.70, 2.60, 2.63, 2.53, 2.61, 2.65, 2.60, 2.63, 2.62, 2.68;...
    2.70, 2.70, 2.67, 2.63, 2.72, 2.71, 2.71, 2.75, 2.72, 2.74;...
    2.60, 2.60, 2.60, 2.50, 2.66, 2.71, 2.69, 2.77, 2.78, 2.81;...
    2.20, 2.60, 2.54, 2.55, 2.68, 2.74, 2.74, 2.67, 2.71, 2.70;...
    2.60, 2.80, 2.65, 2.68, 2.75, 2.79, 2.80, 2.72, 2.86, 2.87;...
    2.60, 2.50, 2.52, 2.43, 2.55, 2.55, 2.57, 2.65, 2.62, 2.65;...
    3.10, 3.00, 2.82, 2.98, 3.06, 3.22, 3.24, 3.28, 3.28, 3.13;...
    2.20, 2.10, 2.14, 2.17, 1.91, 2.05, 2.03, 2.02, 1.87, 1.89;...
    2.70, 2.70, 2.72, 2.68, 2.85, 2.90, 2.88, 2.93, 2.93, 2.93;...
    2.80, 2.30, 2.49, 2.56, 2.69, 2.76, 2.87, 2.95, 3.04, 3.09;...
    2.80, 2.80, 2.82, 2.80, 3.11, 3.11, 3.14, 3.25, 3.16, 3.14;...
    2.80, 2.90, 2.92, 2.88, 3.07, 3.08, 3.08, 3.10, 3.14, 3.09;...
    2.90, 2.70, 2.77, 2.43, 2.50, 2.64, 2.60, 2.52, 2.55, 2.73;...
    3.00, 2.90, 2.72, 2.78, 2.88, 3.01, 2.98, 3.10, 3.17, 3.09;...
    2.40, 2.60, 2.64, 2.60, 2.63, 2.73, 2.71, 2.68, 2.71, 2.69;...
    2.50, 2.50, 2.56, 2.46, 2.62, 2.73, 2.76, 2.69, 2.67, 2.63;...
    2.80, 2.90, 2.80, 2.73, 2.95, 3.01, 2.98, 2.99, 2.98, 3.04;...
    1.80, 1.80, 1.97, 1.89, 1.99, 1.98, 1.96, 2.04, 2.17, 2.09;...
    2.10, 2.20, 2.21, 2.19, 2.26, 2.29, 2.27, 2.30, 2.35, 2.36];

Region_matrix = ...
    {'Ashburton';
    'Banks Peninsula';
    'Buller';
    'Carterton';
    'Central Hawkes Bay';
    'Christchurch City';
    'Clutha';
    'Dunedin City';
    'Far North';
    'Franklin';
    'Gisborne';
    'Gore';
    'Grey';
    'Hamilton City';
    'Hauraki';
    'Horowhenua';
    'Hurunui';
    'Invercargill';
    'Kaikoura';
    'Kaipara';
    'Kapiti Coast';
    'Kawerau/Whakatane';
    'Manawatu';
    'Manukau City';
    'Marlborough';
    'Masterton';
    'Matamata-Piako';
    'Napier/Hastings';
    'Nelson City';
    'New Plymouth';
    'New Zealand';
    'North Island';
    'Opotiki';
    'Otorohanga';
    'Palmerston North City';
    'Papakura';
    'Rangitikei';
    'Rodney';
    'Rotorua';
    'Ruapehu';
    'Selwyn';
    'South Island';
    'South Taranaki';
    'South Waikato';
    'South Wairarapa';
    'Southland';
    'Stratford';
    'Tararua';
    'Tasman';
    'Taupo';
    'Tauranga';
    'Thames-Coromandel';
    'Timaru/MacKenzie';
    'Upper Hutt City';
    'Waikato';
    'Waimakariri';
    'Waimate';
    'Waipa';
    'Wairoa';
    'Waitaki/Central Otago';
    'Waitomo';
    'Wanganui';
    'Western Bay of Plenty';
    'Westland';
    'Whangarei'};


%% Loop over regions

for ii = 1:length(Region_matrix)
    prod_anim = prod_anim_matrix(ii,:);
    
    % display output
    disp('----------------------------------------')
    disp(Region_matrix(ii))
    disp('----------')


    %% Solve for production per animal parameters

    % range of possible base years (b)
    c = 500:0.1:1995;

    % preallocate for speed
    val1 = zeros(size(c));
    val2 = zeros(size(c));
    a1 = zeros(size(c));
    a2 = zeros(size(c));

    % calculate error for each base year
    for ii = 1:length(c)
        [val1(ii) val2(ii) a1(ii) a2(ii)] = find_b(c(ii), year, prod_anim);
    end

    % produce final numbers
    b = find(val1(1:end-1)<0 & val1(2:end)>0);
    if ~all(size(b) == [1 1])
        disp('problem')
        disp(size(b))
        b = 1;
    end
    [~, ~, a, ~] = find_b(c(b), year, prod_anim);

    % display results
    disp('stocking rate (animals / ha)')
    disp('----------')
    disp('logrithmic model')
    display(a)
    display(num2str(c(b)))
    
    %% Repeat solve with linear model
    
    disp('linear model')
    P = polyfit(year, prod_anim, 1);
    display(num2str(P))
    disp('----------')
    
    
%% End loop
end


%%




